var fs = require('fs');

var _ = require('lodash');
var async = require('async');
var moment = require('moment-timezone');

var configs = require('./../../configs');
var api = require('./../api');
var common = require('./common');
var subdomainsUtils = require('./../../utils/subdomains');

var datas = require('./../../data');

var Api = api.contact;

module.exports.get = common.get(Api);
module.exports.render = common.render;

module.exports.getContacts = function (req, res) {
    var subDomain = subdomainsUtils.cleanSiteName(req.subdomains);
    var contacts = _.get(datas, subDomain + ".contacts", []).list || [];
    return res.send(contacts)
};

//todo: unused
module.exports.getMainContact = function (req, res) {
    var subDomain = subdomainsUtils.cleanSiteName(req.subdomains);
    var contacts = _.get(datas, subDomain + ".contacts", []);
    console.log(contacts);
    contacts = _.find(contacts.list, {'main': true});
    if (contacts) return res.send(contacts);
    return res.status('404 domain or main contact not found');
};
