/**
 * Created by ckoppel on 23/05/2016.
 */

// Require Gulp
var gulp = require('gulp');

// Include plugins
var plugins = require("gulp-load-plugins")({
    pattern: ['gulp-*', 'gulp.*', 'main-bower-files', 'run-sequence'],
    replaceString: /\bgulp[\-.]/
});

// Define the destination folder
var dest = 'client/public/';

// Define js files to include before angular
var preAngularFiles = [
  'client/libs/jquery/dist/jquery.min.js',
  'client/libs/moment/min/moment.min.js',
  'client/libs/moment/locale/fr.js',
  'client/libs/fullcalendar/dist/fullcalendar.js',
  // 'client/libs/fullcalendar/dist/gcal.js'
];

var jsFiles = [
	'client/js/*',
  'client/libs/angular-ui-calendar/src/calendar.js',
	'client/js/directives/*',
	'client/js/factories/*',
	'client/js/services/*',
	'client/js/controllers/*'
];

// Define the LESS folder
var lessFiles = [
	'client/less/*'
];

// Define the CSS folder
var cssFiles = [
	'client/libs/AdminLTE/css/*',
	'client/libs/font-awesome/css/*',
	'client/less/css/*',
	'client/libs/bootstrap/dist/css/*',
	'client/libs/iCheck/skins/square/*',
	'client/libs/fullcalendar/dist/fullcalendar.css',
  'client/libs/balloon-css/balloon.min.css',
];

// Define the fonts folder
var fontFiles = [
    'client/libs/font-awesome/fonts/*'
];

/**
 * Task that grabs all the js files and merge and uglify them into one file
 */
gulp.task('js', function() {
    return gulp.src(preAngularFiles.concat(plugins.mainBowerFiles()).concat(jsFiles))
        .pipe(plugins.sourcemaps.init())
        .pipe(plugins.filter('*.js'))
        .pipe(plugins.concat('main.js'))
        //.pipe(plugins.uglify({mangle: false}).on('error', function(e) { console.log('\x07',e.message); return this.end(); }))
        .pipe(plugins.sourcemaps.write('.'))
        .pipe(gulp.dest(dest + 'js'));
});

/**
 * Task that grabs all the js files and merge and uglify them into one file for Production
 */
gulp.task('jsProd', function() {
    return gulp.src(preAngularFiles.concat(plugins.mainBowerFiles()).concat(jsFiles))
        .pipe(plugins.sourcemaps.init())
        .pipe(plugins.filter('*.js'))
        .pipe(plugins.concat('main.js'))
        .pipe(plugins.uglify({mangle: false}).on('error', function(e) { console.log('\x07',e.message); return this.end(); }))
        .pipe(plugins.sourcemaps.write('.'))
        .pipe(gulp.dest(dest + 'js'));
});

/**
 * Task that grabs all the used css files and turn them into one file
 */
gulp.task('css', function() {
    return gulp.src(plugins.mainBowerFiles().concat(cssFiles))
        .pipe(plugins.filter('*.css'))
        .pipe(plugins.concat('main.css'))
        .pipe(plugins.minifyCss().on('error', function(e) { console.log('\x07',e.message); return this.end(); }))
        .pipe(gulp.dest(dest + 'css'));
});

/**
 * Task that grabs all the less files anf turn them into one css files
 */
gulp.task('less', function() {
    return gulp.src(lessFiles)
        .pipe(plugins.sourcemaps.init())
        .pipe(plugins.filter('*.less'))
        .pipe(plugins.concat('concat.less'))
        .pipe(plugins.less().on('error', function(e) { console.log('\x07',e.message); return this.end(); }))
        .pipe(plugins.sourcemaps.write('.'))
        .pipe(gulp.dest('client/less/css'));
});

/**
 * Task that moves the map file created earlier to the dest folder
 */
gulp.task('movecssmap', function(){
    gulp.src('client/less/*')
        .pipe(plugins.filter('*.map'))
        .pipe(gulp.dest(dest + 'css'));

    // delete old www.zip
    gulp.src(['concat.css', 'concat.css.map'])
        .pipe(plugins.clean());
});

/**
 * Task that moves the fonts files
 */
gulp.task('movefonts', function(){
  return gulp.src(fontFiles)
    .pipe(gulp.dest(dest + 'fonts'));
});

/**
 * Create a sequence of less, css and movecssmap tasks
 */
gulp.task('lesscss', function() {
    plugins.runSequence('less', 'css', 'movecssmap');
});

/**
 * Build task
 */
gulp.task('build', function() {
    plugins.runSequence(['js', 'lesscss', 'movefonts']);
});

/**
 * Build task
 */
gulp.task('prod', function() {
    plugins.runSequence(['jsProd', 'lesscss', 'movefonts']);
});

/**
 * Watch task
 */
gulp.task('watch', function() {
    plugins.livereload.listen(35730);
    gulp.watch(jsFiles, ['js']);
    gulp.watch(lessFiles, ['lesscss']);
    gulp.watch(cssFiles, ['lesscss']);
});
