var request = require('request');
var express = require('express');
var router = express.Router();
var utils = require('./../../utils');
var api = require('../api');
var middlewares = require('./../middlewares');

var controllers = require('./../controllers');

/* User Routes */
router.get('/count', middlewares.auth.isAuthenticated, controllers.registration.getCount, controllers.registration.render);
router.get('/', middlewares.auth.isAuthenticated, controllers.registration.getList, controllers.registration.render);


/* Exports modules */
module.exports = {path: '/api/registration', router: router};