'use strict';

var express = require('express');
var router = express.Router();

var controllers = require('../controllers');
var middlewares = require('./../middlewares');

router.get('/years', middlewares.auth.isAuthenticated, controllers.contract.listByYears, controllers.contract.render);
router.get('/', middlewares.auth.isAuthenticated, controllers.contract.getCommission);

module.exports = { path: '/api/commission', router: router };
