var fs = require('fs');

var _ = require('lodash');
var async = require('async');
var moment = require('moment-timezone');

var configs = require('./../../configs');
var api = require('./../api');
var common = require('./common');
var datas = require('./../../data');
var subdomainsUtils = require('./../../utils/subdomains');

var Api = api.site;

module.exports.render = common.render;

module.exports.getCurrent = function(req, res, next) {
  var subdomain = subdomainsUtils.cleanSiteName(req.subdomains);
  var key = _.get(datas, [subdomain, 'commission', 'key']);
  Api.getCurrent(subdomain, req, function(err, response, body) {
    var data = { err: err, response: response, body: body };
    _.set(req, [configs.server.name, 'data'].join('.'), data);
    return next();
  });
};
