var configs = require('./../../configs');
var request = require('../../utils').jwt.request;
var _ = require('lodash');
var common = require('./common');

var defaultOptions = common.defaultOptions();
defaultOptions.url.segment('family');
module.exports.defaultOptions = defaultOptions;

module.exports.get = common.get(defaultOptions);
module.exports.update = common.update(defaultOptions);

module.exports.getList = function (params, search, options, req, cb) {
  params = {};
  params.status = { $ne: '578d47031abaec3e8ac50ca7' }; // H__A supprimer / doublon
  params = JSON.stringify(params);

  var query = {
    params: params,
    search: search,
    options: options
  };

  options = _.clone(defaultOptions);
  options.url = options.url.clone().segment('populated').query(query).toString();
  return request(options, req, cb);
};

module.exports.getCount = function (params, search, req, cb) {
  params = JSON.parse(params) || {};
  params.status = { $ne: '578d47031abaec3e8ac50ca7' }; // H__A supprimer / doublon
  params = JSON.stringify(params);

  var query = {
    params: params,
    search: search
  };

  var options = _.clone(defaultOptions);
  options.url = options.url.clone().segment('countHub').query(query).toString();

  return request(options, req, cb);
};

module.exports.getFlags = function (type, req, cb) {

  var options = _.clone(defaultOptions);
  options.url = options.url.clone().segment('flags').query({type: type}).toString();

  return request(options, req, cb);
};

module.exports.getFamily = function (familyId, req, cb) {

    var options = _.clone(defaultOptions);
    options.url = options.url.clone().segment('/'+familyId).toString();

    return request(options, req, cb);
};
