var ms = require('ms');
var _ = require('lodash');
var request = require('request');
var URI = require('urijs');

var configs = require('../configs');

var uri = new URI({
    protocol: configs.api.protocol,
    hostname: configs.api.hostname,
    port: configs.api.port || null
});
var subomainsUtil = require('../utils/subdomains');

var jwtUrl = uri.clone().segment('auth/token').toString();
var jwt = {};

function authenticate(site, cb) {
    site = subomainsUtil.cleanSiteName(site);
    var siteConf = configs.sites.get(site);
    var options = {
        method: 'POST',
        url: jwtUrl,
        json: {
            id: siteConf.id,
            secret: siteConf.secret
        }
    };
    return request(options, function (err, response, data) {
        site = subomainsUtil.cleanSiteName(site);
        jwt[site] = {
            err: err,
            token: _.get(data, 'token')
        };
        if (cb) return cb();
        return null;
    });
}

function injectToken(options, site, req) {
    site = subomainsUtil.cleanSiteName(site);
    _.set(options, 'headers.Authorization', 'Bearer ' + jwt[site].token);
    _.set(options, 'headers.X-Mpec-User-Id', _.get(req, 'session.user._id'));
    return jwt.err;
};

function connect(site, cb) {
    site = subomainsUtil.cleanSiteName(site);
    if (!jwt[site]) {
        return authenticate(site, function () {
            if (!_.get(jwt, site + '.err')) setInterval(function () {
                authenticate(site)
            }, ms(configs.api.jwtInterval));
            return cb();
        });
    } else {
        return cb();
    }
};

// request wrapper
// TODO: remove the wrapper..
var requestApi = function (options, req, cb) {
    var site = req.subdomains;
    site = subomainsUtil.cleanSiteName(site);
    return connect(site, function () {
        var err = injectToken(options, site, req);
        if (err) return cb(err);
        return request(options, cb);
    });
};

module.exports.request = requestApi;
