'use strict';

var URI = require('urijs');
var request = require('request');
var _ = require('lodash');
var qs = require('qs');
var configs = require('./../../configs');

module.exports = function(path) {

  var defaultOptions = {
    method: 'GET',
    json: true,
    url: new URI({
      protocol: configs.api.protocol,
      hostname: configs.api.hostname,
      port: configs.api.port || null
    }).segment(path)
  };

  this.get = function (req, res, next) {
    var options = {
      url: defaultOptions.url.clone().segment(req.params.id).toString(),
      query: req.query
    };
    options = _.assignIn(_.clone(defaultOptions), options);

    request(options, function(err, response, body) {
      if(err) return next(err);
      _.set(req, [configs.server.name, 'response'].join('.'), response);
      _.set(req, [configs.server.name, 'body'].join('.'), body);
      return next();
    });
  };

  this.list = function (req, res, next) {
    var options = {
      url: defaultOptions.url.clone().query(req.query).toString()
    };
    options = _.assignIn(_.clone(defaultOptions), options);

    request(options, function(err, response, body) {
      if(err) return next(err);
      _.set(req, [configs.server.name, 'response'].join('.'), response);
      _.set(req, [configs.server.name, 'body'].join('.'), body);
      return next();
    });
  };

  this.create = function(req, res, next) {
    var options = {
      method: 'POST',
      url: defaultOptions.url.toString(),
      json: req.body
    };
    options = _.assignIn(_.clone(defaultOptions), options);

    request(options, function(err, response, body) {
      if(err) return next(err);
      _.set(req, [configs.server.name, 'response'].join('.'), response);
      _.set(req, [configs.server.name, 'body'].join('.'), body);
      return next();
    });
  };

  this.update = function(req, res, next) {
    var options = {
      method: 'PUT',
      url: defaultOptions.url.clone().segment(req.params.id).toString(),
      json: req.body
    };
    options = _.assignIn(_.clone(defaultOptions), options);

    request(options, function(err, response, body) {
      if(err) return next(err);
      _.set(req, [configs.server.name, 'response'].join('.'), response);
      _.set(req, [configs.server.name, 'body'].join('.'), body);
      return next();
    });
  };
  
  this.delete = function (req, res, next) {
    var options = {
      method: 'DELETE',
      url: defaultOptions.url.clone().segment(req.params.id).toString()
    };
    options = _.assignIn(_.clone(defaultOptions), options);

    request(options, function(err, response, body) {
      if(err) return next(err);
      _.set(req, [configs.server.name, 'response'].join('.'), response);
      _.set(req, [configs.server.name, 'body'].join('.'), body);
      return next();
    });
  };

  this.request = function (req, res, next) {
    var options = {
      method: _.get(req, [configs.server.name, 'method'].join('.'), defaultOptions.method),
      url: defaultOptions.url.clone().segment(_.get(req, [configs.server.name, 'path'].join('.'), [])).toString(),
      query: _.get(req, [configs.server.name, 'query'].join('.'), {})
    };

    options = _.assignIn(_.clone(defaultOptions), options);

    request(options, function(err, response, body) {
      if(err) return next(err);
      _.set(req, [configs.server.name, 'response'].join('.'), response);
      _.set(req, [configs.server.name, 'body'].join('.'), body);
      return next();
    });
  };

};
