var request = require('request');
var express = require('express');
var router = express.Router();
var utils = require('./../../utils');
var api = require('../api');
var middlewares = require('./../middlewares');

var controllers = require('./../controllers');

/* User Routes */
router.get(/export\.((xlsx)|(csv))/, middlewares.auth.isAuthenticated, controllers.family.export);
router.get('/count', middlewares.auth.isAuthenticated, controllers.family.getCount, controllers.family.render);
router.get('/flags', middlewares.auth.isAuthenticated, controllers.family.getFlags, controllers.family.render);
router.get('/:id/comments', middlewares.auth.isAuthenticated, controllers.family.getFamilyComments, controllers.family.render);
router.get('/status', middlewares.auth.isAuthenticated, controllers.familyStatus.getList, controllers.family.render);
router.get('/', middlewares.auth.isAuthenticated, controllers.family.getList, controllers.family.render);
router.put('/:id/upgrade', middlewares.auth.isAuthenticated, controllers.family.upgrade, controllers.family.render);
router.get('/:id', middlewares.auth.isAuthenticated, controllers.family.getOne, controllers.family.render);


/* Exports modules */
module.exports = {path: '/api/family', router: router};
