var _ = require('lodash');

var configs = require('./../../configs');
var api = require('./../api');
var common = require('./common');

var Api = api.user;

module.exports.get = common.get(Api);
module.exports.update = common.update(Api);
module.exports.render = common.render;

module.exports.login = function (req, res, next) {
  if (!req.body.email || !req.body.password) return next();

  Api.login(req.body.email, req.body.password, req, function (err, response, body) {
    if(err) {
      _.set(req, [configs.server.name, 'data'].join('.'), {err: err});
      return next();
    }

    req.session.user = body;

    //Set Roles and Rights
    var roles = [];
    var rights = [];

    if (!_.isUndefined(req.session.user.roles)) {
      req.session.user.roles.forEach(function (role) {
        if (roles.indexOf(role.key) == -1) {
          roles.push(role.key);
        }

        role.rights.forEach(function (right) {
          if (rights.indexOf(right.key) == -1) {
            rights.push(right.key);
          }
        })
      });
    }

    req.session.roles = roles;
    req.session.rights = rights;

    var data = {err: err, response: response, body: body};
    _.set(req, [configs.server.name, 'data'].join('.'), data);
    return next();
  });
};

module.exports.logout = function (req, res, next) {
  req.session.destroy();
  res.send(true);
};
