'use strict';

var os = require('os');

module.exports = {
  all: {
    name: 'mpec-familyhub',
    pm2: true,
    required: ['mpec-api']
  },
  development: {
    port: 8686,
    instances: 1
  },
  staging: {
    port: 10003,
    pm2: false,
    instances: 1
  },
  qualif: {
    port: 10103,
    instances: 2
  },
  preprod: {
    port: 8686,
    instances: 2
  },
  production: {
    port: 8686,
    instances: os.cpus().length / 2
  },
  'external-prod': {
    port: 8686,
    instances: os.cpus().length / 2
  },
  rproduction: {
    port: 8686,
    instances: os.cpus().length / 2
  }
};
