app.service('AuthService', ['$resource', '$http', '$q', '_', function($resource, $http, $q, _) {
  var data = {
    user: JSON.parse(localStorage.getItem('auth_user')),
    roles: JSON.parse(localStorage.getItem('auth_roles')),
    rights: JSON.parse(localStorage.getItem('auth_rights'))
  };

  function setUser(value) {
    data.user = value;
    localStorage.setItem('auth_user', JSON.stringify(data.user));
  }

  function setRoles(values) {
    data.roles = values;
    localStorage.setItem('auth_roles', JSON.stringify(data.roles));
  }

  function setRights(values) {
    data.rights = values;
    localStorage.setItem('auth_rights', JSON.stringify(data.rights));
  }


  this.setUser = setUser;

  this.login = function(email, password) {
    var deferred = $q.defer();
    $http.post('auth/login', {
      'email' : email,
      'password' : password
    }).success(function(user) {
      setUser(user);

      //Set Roles and Rights
      var roles = [];
      var rights = [];

      user.roles.forEach(function(role) {
        if (roles.indexOf(role.key) == -1) {
          roles.push(role.key);
        }

        role.rights.forEach(function(right) {
          if (rights.indexOf(right.key) == -1) {
            rights.push(right.key);
          }
        })
      });
      setRoles(roles);
      setRights(rights);

      deferred.resolve(user);
    }).error(function(err) {
      deferred.reject(err);
    });
    return deferred.promise;
  };

  this.logout = function() {
    setUser(null);
    setRoles([]);
    setRights([]);

    return $http.get('auth/logout');
  };

  this.isAuthenticated = function() {
    return data.user !== null;
  };

  this.isAuthorized = function(authorizedRights) {
    if(authorizedRights.length == 0 || _.intersection(data.rights, authorizedRights).length > 0 ) {
      return true;
    } else {
      return false;
    }
  };

  this.getAuthenticatedUser = function() {
    return data;
  };
}]);
