var env = require('./env');

module.exports.cleanSubdomains = function (subdomains) {
    switch (env) {
        case "development":
        case "staging":
        case "qualif":
        case "external-prod":
            subdomains = subdomains.filter((value) => {
                return value !== "staging" && value != "qualif" && value != "local";
            });
            break;
        default:
            break;
    }
    subdomains = subdomains.join('.');
    return subdomains;
};

module.exports.cleanSiteName = function (siteName) {
    if (typeof siteName === "string") {
        return siteName;
    }
    siteName = this.cleanSubdomains(siteName);
    return siteName;
};