'use strict'

var env = require('./../utils/env')
switch (env) {
  case 'development':
  case 'staging':
  case 'qualif':
  case 'external-prod':
  case 'production':
    //  Disable pm2 metrics for new env waiting to understand how it works
    break
  default:
    require('@pm2/io').init({
      metrics: {
        network: {ports: true},
        transaction: {tracing: {}}
      }
    })
    break
}


var _ = require('lodash'),
  moment = require('moment'),
  express = require('express'),
  bodyParser = require('body-parser'),
  ejsmate = require('ejs-mate'),
  session = require('express-session'),
  RedisStore = require('connect-redis')(session)

var configs = require('./../configs'),
  utils = require('./../utils'),
  routes = require('./routes')

var app = express()

app.disable('x-powered-by')

// Sessions
app.use(session({
  store: new RedisStore(configs.db.redis),
  secret: '12345',
  resave: false,
  saveUninitialized: false
}))

// Views engine
app.engine('ejs', ejsmate)
app.set('view engine', 'ejs')
app.set('views', __dirname + '/views')

// Static files
app.use(express.static(__dirname + '/../client'))

// Body parser
app.use(bodyParser.urlencoded({extended: true}))
app.use(bodyParser.json())

// Moment
_.set(app, 'locals.moment', moment)

// Routes
_.forEach(routes, function (route) {
  app.use(route.path, route.router)
})

app.listen(configs.server.port, function () {
  console.log('Express server listening in %s mode on port %d', utils.env, configs.server.port)
})
