var configs = require('./../../configs');
var api = require('./../api');
var datas = require('./../../data');
var _ = require('lodash');
var Api = api.application;

module.exports.getCurrent = function(req, res, next) {
    var subdomains = req.subdomains;
    var subdomain = _.get(subdomains, '0');
    var key = _.get(datas, [subdomain, 'commission', 'key']);
    if(subdomain && key && _.toLower(subdomain) === _.toLower(key))
        _.set(subdomains, '0', key);
    Api.getCurrent(subdomains, req, function(err, response, body) {
        var data = { err: err, response: response, body: body };
        _.set(req, [configs.server.name, 'data'].join('.'), data);
        return next();
    });
};