var _ = require('lodash');

var configs = require('./../../configs');
var api = require('./../api');
var common = require('./common');
var datas = require('./../../data');
var subdomainsUtils = require('./../../utils/subdomains');

var Api = api.contract;

var toOmit = [
    'attachment', 'bill', 'capTerminate', 'price', 'date.bdc', 'date.free', 'date.interest',
    'date.priceAnticipated', 'date.signed', 'data.terminated', 'date.cancelled', 'locked',
    'mail', 'pipe', 'category', 'rc', 'saleType'
]

module.exports.render = function (req, res, next) {
    var body = _.get(req, [configs.server.name, 'data', 'body'].join('.'));
    if (body) {
        var cBody = _.cloneDeep(body);
        if (!_.isArray(body)) cBody = [cBody];
        for (var i = 0; i < cBody.length; i++)
            cBody[i] = _.omit(cBody[i], toOmit);
        if (!_.isArray(body)) _.set(req, [configs.server.name, 'data', 'body'].join('.'), cBody[0]);
        else _.set(req, [configs.server.name, 'data', 'body'].join('.'), cBody);
    }
    return common.render(req, res, next);
}

module.exports.listByYears = function (req, res, next) {
    Api.listByYears(req.query.years, req.query.commission, req, function (err, response, body) {
        var data = {err: err, response: response, body: body};
        _.set(req, [configs.server.name, 'data'].join('.'), data);
        res.statusCode = 200
        return next();
    });
};

module.exports.getCommission = function (req, res, next) {
    var subdomain = subdomainsUtils.cleanSiteName(req.subdomains);
    var commission = (datas[subdomain].commission) ? datas[subdomain].commission : false;
    if (commission) return res.send(commission);
    return res.status('404 domain not found');
};
