var fs = require('fs');

var _ = require('lodash');
var async = require('async');
var moment = require('moment-timezone');

var configs = require('./../../configs');
var api = require('./../api');
var common = require('./common');

var Api = api.familyHistory;

module.exports.render = common.render;

module.exports.getList = function(req, res, next) {
    Api.getList(req.query.family, req.query.type, req.query.start, function(err, response, body) {
        var data = { err: err, response: response, body: body };
        _.set(req, [configs.server.name, 'data'].join('.'), data);
        return next();
    });
}
