var configs = require('./../../configs');
var request = require('../../utils').jwt.request;
var _ = require('lodash');
var common = require('./common');

var defaultOptions = common.defaultOptions();
defaultOptions.url.segment('familyStatus');
module.exports.defaultOptions = defaultOptions;

module.exports.get = common.get(defaultOptions);

module.exports.getList = function (params, search, options, req, cb) {
  var query = {
    params: params,
    search: search,
    options: options
  };

  options = _.clone(defaultOptions);
  options.url = options.url.clone().query(query).toString();

  return request(options, req, cb);
};

module.exports.getCount = function (params, search, req, cb) {
  var query = {
    params: params,
    search: search
  };

  var options = _.clone(defaultOptions);
  options.url = options.url.clone().segment('count').query(query).toString();

  return request(options, req, cb);
};
