var configs = require('./../../configs');
var request = require('../../utils').jwt.request;
var _ = require('lodash');
var common = require('./common');
var subdomainsUtils = require('./../../utils/subdomains');

var defaultOptions = common.defaultOptions();
defaultOptions.url.segment('site');
module.exports.defaultOptions = defaultOptions;

module.exports.getCurrent = function (subdomains, req, cb) {
    var subdomain = subdomainsUtils.cleanSiteName(subdomains);
    var query = { subdomains: subdomain, active: true };
    var options = _.clone(defaultOptions);
    options.url = options.url.clone().segment('current').query(query).toString();

    return request(options, req, cb);
};
