var _ = require('lodash');
var URI = require('urijs');
var request = require('../../utils').jwt.request;

var configs = require('./../../configs');

module.exports.defaultOptions = function() {
  return {
    method: 'GET',
    json: true,
    url: new URI({
      protocol: configs.api.protocol,
      hostname: configs.api.hostname,
      port: configs.api.port || null
    })
  }
};

module.exports.get = function(defaultOptions) {
  return function(params, req, cb) {
    var options = {
      url: defaultOptions.url.clone().segment(params.id).toString(),
      query: params.query
    };
    options = _.assignIn(_.clone(defaultOptions), options);
    return request(options, req, cb);
  }
};

module.exports.create = function(defaultOptions) {
  return function(params, req, cb) {
    var options = {
      method: 'POST',
      url: defaultOptions.url.toString(),
      json: params.body
    }
    options = _.assignIn(_.clone(defaultOptions), options);
    return request(options, req, cb);
  };
};

module.exports.update = function(defaultOptions) {
  return function(params, req, cb) {
    var options = {
      method: 'PUT',
      url: defaultOptions.url.clone().segment(params.id).toString(),
      json: params.body
    };
    options = _.assignIn(_.clone(defaultOptions), options);
    return request(options, req, cb);
  };
};

module.exports.delete = function(defaultOptions) {
  return function(params, req, cb) {
    var options = {
      method: 'DELETE',
      url: defaultOptions.url.clone().segment(params.id).toString()
    };
    options = _.assignIn(_.clone(defaultOptions), options);
    return request(options, req, cb);
  };
};
