var _ = require('lodash');

module.exports = {
  isAuthenticated :function(req, res, next) {
    if (req.session && !_.isUndefined(req.session.user)) {
      var userId = _.get(req, 'session.user._id');
      _.set(req, 'access.userId', userId);
      return next();
    } else {
      return res.status(401).send('Not connected');
    }
  },
  isAuthorized :function(rights) {
    return function(req, res, next) {
      if (req.session && !_.isUndefined(req.session.user)) {
        if(!_.isUndefined(req.session.rights) && (rights.length == 0 || _.intersection(req.session.rights, rights).length > 0)) {
          return next();
        } else {
          return res.status(403).send('Not authorized');
        }
      } else {
        return res.status(401).send('Not connected');
      }
    };
  },
};
