var _ = require('lodash');
var request = require('request');

var configs = require('./../../configs');
var subdomainsUtils = require('./../../utils/subdomains');

module.exports.get = function(Api) {
  return function(req, res, next) {
    // var userId = _.get(req, 'session.user._id', undefined);
    // var params = { id: req.params.id, userId: userId };
    Api.get(params, req, function(err, response, body) {
      var data = { err: err, response: response, body: body };
      _.set(req, [configs.server.name, 'data'].join('.'), data);
      return next();
    });
  }
}

module.exports.update = function(Api) {
  return function(req, res, next) {
    var subDomain = subdomainsUtils.cleanSiteName(req.subdomains);
    Api.update(req.query.params, subDomain, function(err, response, body) {
      var context = { err: err, response: response, body: body };
      _.set(req, [configs.server.name, 'data'].join('.'), context);
      return next();
    });
  }
}

module.exports.render = function(req, res, next) {
  var data = _.get(req, [configs.server.name, 'data'].join('.'));
  if(data.err) return res.status(500).json(data.err);
  // if(!data.response) return res.status(500);
  res.status(200).json(data.body);
}
