var configs = require('./../../configs');
var request = require('../../utils').jwt.request;
var _ = require('lodash');
var common = require('./common');
const subdomainsUtils = require("../../utils/subdomains");
const axios = require("axios");

var defaultOptions = common.defaultOptions();
defaultOptions.url.segment('contract');
module.exports.defaultOptions = defaultOptions;

module.exports.listByYears = async function (years, commission, req, cb) {
  var query = {
    years: years,
    commission: commission
  };

  var options = _.clone(defaultOptions);
  options.url = options.url.clone().segment('listByYears').query(query).toString();

  const mySite = subdomainsUtils.cleanSiteName(req.subdomains);
  const myConfig = configs.sites.get(mySite);
  const newOptions = {
    data: {
      application: myConfig.id,
      years
    },
    method: "POST",
    url: "/family-hub/old-commission/by/years"
  };
  const test = await doRequest(newOptions)
  return cb(null, null, test.data._embedded)
  // return request(options, req, cb);
};

function doRequest (options) {
  _.set(options, 'headers', {
    'content-type': 'application/json',
    'accept': 'application/json',
    'x-mpec-sessionid': '493fe50c-ee04-4414-a4a6-f901578fe35e',
    'x-mpec-appid': 'b9736d55-ec99-4fc7-a34b-318928fd5871'
  })
  _.set(options, 'method', _.get(options, 'method') || 'GET')
  _.set(options, 'responseType', 'json')
  _.set(options, 'baseURL', configs.apiV2.protocol + '://' + configs.apiV2.hostname)
  console.log(options)
  var responseString = '';
  return new Promise((resolve, reject) => {
    axios.request(options).then((response) => {
      console.log("GOT response into axios DoRequest", response.status)
      console.log({data: response.data})
      if (response.status < 300) {
        resolve(response)
      } else {
        console.log({data: JSON.stringify(response.data), response})
        reject({code: response.status, message: response.statusText, response})
      }
    }).catch(
      (reason) => {
        console.log("GOT exception into axios DoRequest")
        console.log({reason})
        resolve(reason.response)
      }
    );
  }).catch(reason => {
    console.log({doRequestCatch: reason})
  });
}
module.exports.doRequest = doRequest