var configs = require('./../../configs');
var request = require('../../utils').jwt.request;
var _ = require('lodash');
var common = require('./common');
const subdomainsUtils = require("../../utils/subdomains");
const {doRequest} = require("./contract");

var defaultOptions = common.defaultOptions();
defaultOptions.url.segment('family');
module.exports.defaultOptions = defaultOptions;

module.exports.get = common.get(defaultOptions);
module.exports.update = common.update(defaultOptions);

module.exports.getList = async function (params, search, options, req, cb) {
  params = {};
  params.status = {$ne: '578d47031abaec3e8ac50ca7'}; // H__A supprimer / doublon
  params = JSON.stringify(params);

  var query = {
    params: params,
    search: search,
    options: options
  };

  options = _.clone(defaultOptions);
  options.url = options.url.clone().segment('populated').query(query).toString();
  const mySite = subdomainsUtils.cleanSiteName(req.subdomains);
  const myConfig = configs.sites.get(mySite);
  const newOptions = {
    data: {
      application: myConfig.id,
    },
    method: "POST",
    url: "/family-hub/family/children/list"
  };
  const test = await doRequest(newOptions)
  return cb(null, null, test.data._embedded)
  // return request(options, req, cb);
};

module.exports.getCount = function (params, search, req, cb) {
  params = JSON.parse(params) || {};
  params.status = { $ne: '578d47031abaec3e8ac50ca7' }; // H__A supprimer / doublon
  params = JSON.stringify(params);

  var query = {
    params: params,
    search: search
  };

  var options = _.clone(defaultOptions);
  options.url = options.url.clone().segment('countHub').query(query).toString();

  return request(options, req, cb);
};

module.exports.getFlags = function (type, req, cb) {

  var options = _.clone(defaultOptions);
  options.url = options.url.clone().segment('flags').query({type: type}).toString();

  return request(options, req, cb);
};

module.exports.getFamily = function (familyId, req, cb) {

    var options = _.clone(defaultOptions);
    options.url = options.url.clone().segment('/'+familyId).toString();

    return request(options, req, cb);
};
